/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.search;

import filenet.vw.api.VWLog;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.search.VWBaseSearchOptions;
import filenet.vw.toolkit.admin.search.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.query.VWScopeChangeEvent;
import javax.swing.JOptionPane;

class VWEventLogSearchOptions
extends VWBaseSearchOptions {
    public VWEventLogSearchOptions() {
        this.m_name = VWResource.s_events;
        this.m_nVisibleTabs = 14;
    }

    public VWScopeChangeEvent createScopeChangeEvent(Object source, VWSession session) {
        VWScopeChangeEvent scEvent = null;
        if (VWStringUtils.compare(this.m_selectedScope, this.m_eventLogItem) == 0) {
            scEvent = this.createLogScopeChangeEvent(source, session);
        }
        return scEvent;
    }

    public int getResultType() {
        return 3;
    }

    public String[] getScopeOptions() {
        String[] items = null;
        try {
            items = new String[]{this.m_eventLogItem};
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return items;
    }

    public String[] getSpecificScopeOptions() {
        return this.m_eventLogNames;
    }

    protected VWScopeChangeEvent createLogScopeChangeEvent(Object source, VWSession session) {
        VWLog vwLog = null;
        VWLogDefinition vwLogDef = null;
        VWScopeChangeEvent scEvent = null;
        try {
            if (session != null) {
                try {
                    vwLog = session.fetchEventLog(this.m_selectedSpecificScope);
                    vwLogDef = vwLog.fetchLogDefinition();
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    JOptionPane.showMessageDialog(null, ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
                }
            }
            scEvent = new VWScopeChangeEvent(source);
            scEvent.setType(3);
            scEvent.setDefinitionObject(vwLogDef);
            scEvent.setDefaultColumns(this.getDefaultColumns(vwLogDef));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return scEvent;
    }
}

